EvaluateSystemScript("screen.js");

// This will make the screen flash a certain color
function Flash(color)
{
	SetColorMask(color, 0);	
	FadeFromColor(500, color);
}

function Quake(length, strength)
{
	var image = GrabImage(0, 0, 320, 240);
	var start = GetTime();
	while (start + length > GetTime())
	{
		image.blit(0 + Math.random() * strength, 0 + Math.random() * strength);
		FlipScreen();
	}
}

function ZoomIn(speed, time)
{
	var factor = 1;
	var timer = GetTime();
	var image = GrabImage(0, 0, 320, 240);
	while (timer + time > GetTime())
	{
		image.zoomBlit(0 - (factor - 1), 0 - (factor - 1), 319 + (factor - 1), 0 - (factor - 1), 319 + (factor - 1), 239 + (factor - 1), 0 - (factor - 1), 239 + (factor - 1));
		FlipScreen();
		factor += speed*10;
	}
}

function ZoomOut()
{

}

function Swish(speed, time)
{
	var fps = GetFrameRate();
	SetFrameRate(10);
	var timer = GetTime();
	var degree = 0;
	var alpha = 0;
	var image = GrabImage(0, 0, 320, 240);
	while (timer + time > GetTime())
	{
		image.blit(0, 0);
		image.rotateBlit(0, 0, DtR(degree));
		Fade(alpha, Colors.Black);
		var image = GrabImage(0, 0, 320, 240);
		FlipScreen();
		degree += speed/3;
		alpha += 1;
	}
	SetFrameRate(fps);
}

function RotateBlitMask(x, y, radians, mask, image)
{
	var w = image.width;
	var h = image.height;
	var r = Math.sqrt(w * w + h * h);
	var angle = Math.atan(w / h);
	var ulangle = -angle;
	var urangle = angle;
	var blangle = Math.PI - angle;
	var brangle = Math.PI + angle;
	var cx = x + w / 2;
	var cy = y + h / 2;
	var tx = new Array(4);
	tx[0] = cx + r * Math.sin(ulangle + radians);
	tx[1] = cx + r * Math.sin(urangle + radians);
	tx[2] = cx + r * Math.sin(brangle + radians);
	tx[3] = cx + r * Math.sin(blangle + radians);
	var ty = new Array(4);
	ty[0] = cy - r * Math.cos(ulangle + radians);
	ty[1] = cy - r * Math.cos(urangle + radians);
	ty[2] = cy - r * Math.cos(brangle + radians);
	ty[3] = cy - r * Math.cos(blangle + radians);
	image.transformBlitMask(tx[0], ty[0], tx[1], ty[1], tx[2], ty[2], tx[3], ty[3], mask);
}